
#include <stdio.h>
#include "tx_api.h"
#include "gx_api.h"

/* Include GUIX resource and specification files for example. */

#include "hello_world_resources.h"
#include "hello_world_specifications.h"

/* Define the new example thread control block and stack. */

TX_THREAD guix_thread;
UCHAR guix_thread_stack[4096];

/* Define the root window pointer. */

GX_WINDOW_ROOT* root_window;

/* Define function prototypes. */

VOID guix_thread_entry(ULONG thread_input);
UINT win32_graphics_driver_setup_565rgb(GX_DISPLAY* display);

int toggle = 0;

int main(int argc, char** argv)
{
    /* Enter the ThreadX kernel. */
    tx_kernel_enter();
    return(0);
}

VOID tx_application_define(void* first_unused_memory)
{
    /* Create the new example thread. */
    tx_thread_create(&guix_thread, "GUIX Thread", guix_thread_entry, 0, guix_thread_stack, sizeof(guix_thread_stack), 1, 1, TX_NO_TIME_SLICE, TX_AUTO_START);
}

VOID guix_thread_entry(ULONG thread_input)
{

    /* Initialize the GUIX library */
    gx_system_initialize();

    /* Configure the main display. */
    gx_studio_display_configure(MAIN_DISPLAY,  /* Display to configure*/
        win32_graphics_driver_setup_565rgb, /* Driver to use */
        LANGUAGE_ENGLISH,                  /* Language to install */
        0,        /* Theme to install */
        &root_window);                     /* Root window pointer */

    /* Create the screen - attached to root window. */
    gx_studio_named_widget_create("hello_world", (GX_WIDGET*)root_window, GX_NULL);

    /* Show the root window to make it visible. */
    gx_widget_show(root_window);

    /* Let GUIX run. */
    gx_system_start();

}


UINT app_event_handler(GX_WINDOW* window, GX_EVENT* event_ptr)
{

    switch (event_ptr->gx_event_type)
    {

    case GX_SIGNAL(ID_BUTTON_CLICKME, GX_EVENT_CLICKED):

        if (toggle == 0) {
            /* Clear input buffer.  */
            gx_single_line_text_input_buffer_clear(&hello_world.hello_world_text_input);
            gx_single_line_text_input_character_insert(&hello_world.hello_world_text_input, "Welcome to", 10);

            toggle = 1;
        }
        else
        {
            gx_single_line_text_input_buffer_clear(&hello_world.hello_world_text_input);
            gx_single_line_text_input_character_insert(&hello_world.hello_world_text_input, "Azure RTOS", 10);
            toggle = 0;
        }
        break;

    default:

        return gx_window_event_process(window, event_ptr);
    }

    return 0;
}