// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreeUnits.c
*
* DESCRIPTION:  This is the thread module for ThreeUnits.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4WandR.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreeUnits
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore ThreeUnits.
\*****************************************************************************/

void      ThreadThreeUnits(void)
{
//--
//  RTHANDLE  hThreeUnits;
//--

//++
  DWORD dwUnitsRemain;
//++

#ifdef _DEBUG
  printf("Thread for ThreeUnits started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//--
//  hThreeUnits = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hThreeUnits == BAD_RTHANDLE)
//    Fail("Cannot create semaphore ThreeUnits");
//  if (!Catalog(NULL_RTHANDLE, hThreeUnits, "ThreeUnits"))
//    Fail("Cannot catalog semaphore ThreeUnits");
//--

  while (1) {
#ifdef _DEBUG
    printf("Thread for ThreeUnits waiting\n");
#endif

//+-
    if ( (dwUnitsRemain = WaitForRtSemaphore(hWandR, 3, WAIT_FOREVER)) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hWandR");

//+-

    // TODO: operate on received unit
//++
  printf("ThreeUnits received 3 units; %d units remain\n", dwUnitsRemain);
//++

  }
}
