// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    PollThread1.c
*
* DESCRIPTION:  This is polling module PollThread1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4WandR.h"


/*****************************************************************************
*
* FUNCTION:		PollThread1
*
* PARAMETERS:	None
*
* RETURNS:		None
*
* DESCRIPTION:  This is polling thread PollThread1.
\*****************************************************************************/

void			PollThread1(void)
{
//++
  DWORD dwUnits;
//++

#ifdef _DEBUG
	printf("PollThread1 started\n");

#endif
	while (1)
	{
		RtSleep(1000);

#ifdef _DEBUG
		printf("PollThread1 waking up\n");
#endif

		// TODO: do what has to be done every 1000 milliseconds
//++
    // Find out how many units the semaphore has
    dwUnits = WaitForRtSemaphore(hWandR, 0, 0);

    printf("Current semaphore units = %d\n", dwUnits);

    // Release units to the the shared semaphore
    if (!ReleaseRtSemaphore(hWandR, (WORD) (5 - dwUnits)))
    {
      Fail("Unit release failed!");
    }

    printf("Released %d units to the Semaphore\n", (5 - dwUnits));
//++
	}
}
