// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    OneUnit.c
*
* DESCRIPTION:  This is the thread module for OneUnit.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4WandR.h"


/*****************************************************************************
*
* FUNCTION:   ThreadOneUnit
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore OneUnit.
\*****************************************************************************/

void      ThreadOneUnit(void)
{
//--
//  RTHANDLE  hOneUnit;
//--

//++
  DWORD dwUnitsRemain;
//++

#ifdef _DEBUG
  printf("Thread for OneUnit started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//--
//  hOneUnit = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hOneUnit == BAD_RTHANDLE)
//    Fail("Cannot create semaphore OneUnit");
//  if (!Catalog(NULL_RTHANDLE, hOneUnit, "OneUnit"))
//    Fail("Cannot catalog semaphore OneUnit");
//--

  while (1) {
#ifdef _DEBUG
    printf("Thread for OneUnit waiting\n");
#endif

//+-
    if ( (dwUnitsRemain = WaitForRtSemaphore(hWandR, 1, WAIT_FOREVER)) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hWandR");
//+-

    // TODO: operate on received unit
//++
  printf("OneUnit received 1 unit; %d units remain\n", dwUnitsRemain);
//++

  }
}
