// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    FiveUnits.c
*
* DESCRIPTION:  This is the thread module for FiveUnits.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4WandR.h"


/*****************************************************************************
*
* FUNCTION:   ThreadFiveUnits
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore FiveUnits.
\*****************************************************************************/

void      ThreadFiveUnits(void)
{
//--
//  RTHANDLE  hFiveUnits;
//--

//++
  DWORD dwUnitsRemain;
//++

#ifdef _DEBUG
  printf("Thread for FiveUnits started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//--
//  hFiveUnits = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hFiveUnits == BAD_RTHANDLE)
//    Fail("Cannot create semaphore FiveUnits");
//  if (!Catalog(NULL_RTHANDLE, hFiveUnits, "FiveUnits"))
//    Fail("Cannot catalog semaphore FiveUnits");
//--

  while (1) {
#ifdef _DEBUG
    printf("Thread for FiveUnits waiting\n");
#endif

//+-
    if ( (dwUnitsRemain = WaitForRtSemaphore(hWandR, 5, WAIT_FOREVER)) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hWandR");
//+-

    // TODO: operate on received unit
//++
  printf("FiveUnits received 5 units; %d units remain\n", dwUnitsRemain);
//++

  }
}
