// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreadC.c
*
* DESCRIPTION:  This is the thread module for ThreadC.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4PriInvert.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreadC
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore ThreadC.
\*****************************************************************************/

void      ThreadThreadC(void)
{
//+-
//  RTHANDLE  hThreadC;
//+-
//++
  SHORT Counter;
  SHORT Iterations = 0;
  SHORT Cycle = 0;
//++

#ifdef _DEBUG
  printf("Thread for ThreadC started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//+-
//  hThreadC = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hThreadC == BAD_RTHANDLE)
//    Fail("Cannot create semaphore ThreadC");
//  if (!Catalog(NULL_RTHANDLE, hThreadC, "ThreadC"))
//    Fail("Cannot catalog semaphore ThreadC");
//+-

//+-
  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ThreadC waiting for start event semaphore\n");
#endif

    if (WaitForRtSemaphore(hThreadCevent, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore ThreadC");
//+-

//+-
#ifdef _DEBUG
    printf("ThreadC waiting for mutex semaphore\n");
#endif

    if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hMutex");
//+-

//++
    printf("ThreadC has control of mutex semaphore\n");
//++

  while (1) {

    // TODO: operate on received unit
//++
    // Do some busy work here to keep the tread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ThreadC completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 3)
    {
      //Increment cycle count
      Cycle++;

      //Every 3rd cycle don't release the semaphore
      if ( (Cycle % 3) != 0)
      {
        printf("ThreadC releasing the mutex semaphore\n");
        if ( !ReleaseRtSemaphore(hMutex, 1) )
        {
          Fail("ThreadC failed to release semaphore!");
        }
      }
      Iterations = 0;
      if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
        Fail("Cannot receive from semaphore hMutex");
      printf("ThreadC has the mutex semaphore, again\n");
    }

//++
  }
}
