// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreadB.c
*
* DESCRIPTION:  This is the thread module for ThreadB.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4PriInvert.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreadB
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore ThreadB.
\*****************************************************************************/

void      ThreadThreadB(void)
{
//+-
//  RTHANDLE  hThreadB;
//+-
//++
  SHORT Counter;
  SHORT Iterations = 0;
//++

#ifdef _DEBUG
  printf("Thread for ThreadB started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//+-
//  hThreadB = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hThreadB == BAD_RTHANDLE)
//    Fail("Cannot create semaphore ThreadB");
//  if (!Catalog(NULL_RTHANDLE, hThreadB, "ThreadB"))
//    Fail("Cannot catalog semaphore ThreadB");
//+-

//+-
  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ThreadB waiting for start event semaphore\n");
#endif

    if (WaitForRtSemaphore(hThreadBevent, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore ThreadB");
//+-

//++
    printf("ThreadB running\n");

    // Release ThreadC
    printf("ThreadB is releasing ThreadC\n");

    if ( !ReleaseRtSemaphore(hThreadCevent, 1) )
    {
      Fail("ThreadB failed to release hThreadCevent semaphore!");
    }

//++

  while (1) {

    // TODO: operate on received unit
//++
    // Do some busy work here to keep the thread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ThreadB completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 10)
    {
      printf("ThreadB sleeping\n");
      Iterations = 0;
      RtSleep(1000);
      printf("ThreadB waking up\n");

    }
//++
  }
}
