// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreadA.c
*
* DESCRIPTION:  This is the thread module for ThreadA.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4PriInvert.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreadA
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore ThreadA.
\*****************************************************************************/

void      ThreadThreadA(void)
{
//+-
//  RTHANDLE  hThreadA;
//+-
//++
  SHORT Counter;
  SHORT Iterations = 0;
//++

#ifdef _DEBUG
  printf("Thread for ThreadA started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//+-
//  hThreadA = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hThreadA == BAD_RTHANDLE)
//    Fail("Cannot create semaphore ThreadA");
//  if (!Catalog(NULL_RTHANDLE, hThreadA, "ThreadA"))
//    Fail("Cannot catalog semaphore ThreadA");
//+-

//+-
  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ThreadA waiting for start event semaphone\n");
#endif

    if (WaitForRtSemaphore(hThreadAevent, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore ThreadA");
//+-

//+-
#ifdef _DEBUG
    printf("ThreadA waiting for mutex semaphone\n");
#endif

    if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hMutex");
//+-

//++
    printf("ThreadA has control of mutex semaphore\n");

    // Release ThreadB
    printf("ThreadA releasing ThreadB\n");

    if ( !ReleaseRtSemaphore(hThreadBevent, 1) )
    {
      Fail("ThreadA failed to release hThreadBevent semaphore!");
    }

//++

  while (1) {

    // TODO: operate on received unit
//++
    // Do some busy work here to keep the tread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ThreadA completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 5)
    {
      printf("ThreadA releasing the mutex semaphore\n");
      if ( !ReleaseRtSemaphore(hMutex, 1) )
      {
        Fail("ThreadA failed to release semaphore!");
      }
      Iterations = 0;
      if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
        Fail("Cannot receive from semaphore hMutex");
      printf("ThreadA has the mutex semaphore, again\n");
    }
//++
  }
}
