// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    Writer.c
*
* DESCRIPTION:  This is the thread module for Writer.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
//++
#include <stdlib.h>
//+

#include "Sema4Mutex.h"


/*****************************************************************************
*
* FUNCTION:   ThreadWriter
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore Writer.
\*****************************************************************************/

void      ThreadWriter(void)
{
//--
//  RTHANDLE  hWriter;
//--

//++
  int iIter = 0;
  int iChars;
//++

#ifdef _DEBUG
  printf("Thread for Writer started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//--
//  hWriter = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hWriter == BAD_RTHANDLE)
//    Fail("Cannot create semaphore Writer");
//  if (!Catalog(NULL_RTHANDLE, hWriter, "Writer"))
//    Fail("Cannot catalog semaphore Writer");
//--

//+-
  while (iIter <= MAX_ITERS) {
//+-
#ifdef _DEBUG
    printf("Thread for Writer waiting\n");
#endif

//+-
    if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore Writer");
//+-

    // TODO: operate on received unit
//++
    // Check that shared buffer is empty
    // Increment iteration count
    iIter++;

    if ( strlen(cSharedBuff) == 0 )
    {
      // Write to shared buffer
      iChars = sprintf(cSharedBuff, "String write iteration: %d", iIter);
      printf("Writer thread wrote %d chars\n", iChars);
    }
    else
    {
      printf("Error! Shared buffer not zeroed\n");
    }

    // Release semaphore
    if ( !ReleaseRtSemaphore(hMutex, 1) )
    {
      Fail("Writer semaphore release failed!");
    }

//++
  }

//++
  // Signal parent process to exit
  printf("Exiting Sema4Mutex\n");
  exit(0);
//++
}
