// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    Reader.c
*
* DESCRIPTION:  This is the thread module for Reader.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "Sema4Mutex.h"


/*****************************************************************************
*
* FUNCTION:   ThreadReader
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for semaphore Reader.
\*****************************************************************************/

void      ThreadReader(void)
{
//--
//  RTHANDLE  hReader;
//--

#ifdef _DEBUG
  printf("Thread for Reader started\n");
#endif

  // TODO: modify the parameters in the following call if they are not appropriate
//--
//  hReader = CreateRtSemaphore(0, 128, FIFO_QUEUING);
//  if (hReader == BAD_RTHANDLE)
//    Fail("Cannot create semaphore Reader");
//  if (!Catalog(NULL_RTHANDLE, hReader, "Reader"))
//    Fail("Cannot catalog semaphore Reader");
//--

  while (1) {
#ifdef _DEBUG
    printf("Thread for Reader waiting\n");
#endif

//+-
    if (WaitForRtSemaphore(hMutex, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore Reader");
//+-
    // TODO: operate on received unit
//++
    // Print shared buffer
    printf("%s\n", cSharedBuff);

    // Zero shared buffer
    cSharedBuff[0] = 0;

    // Release semaphore
    if ( !ReleaseRtSemaphore(hMutex, 1) )
    {
      Fail("Reader semaphore release failed!");
    }
//++
  }
}
