// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ClientThread3.c
*
* DESCRIPTION:  This is client module ClientThread3.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
#include <string.h>

#include "RegionPriInvert.h"


void ClientThread3(void)
{
//--
//  RTHANDLE    hRegion;

//  hRegion = CreateRtRegion(FIFO_QUEUING);
//  if (hRegion == BAD_RTHANDLE)
//    Fail("Cannot create region");
//--
//++
  SHORT Counter;
  SHORT Iterations = 0;

#ifdef _DEBUG
  printf("ClientThread3 started\n");
#endif

  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ClientThread3 waiting for start event semaphore\n");
#endif

    if (WaitForRtSemaphore(hClientThread3event, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hClientThread3event");

#ifdef _DEBUG
    printf("ClientThread3 waiting for mutex region\n");
#endif

    if (!WaitForRtControl(hMutex))
      Fail("Cannot enter region hMutex");

    printf("ClientThread3 has control of mutex region\n");
//++
  while (1)
  {
    // TODO: put client code that must be repeated here
//--
    // the RtSleep call is just an example
//    RtSleep(1000);
//--

//++
    // Do some busy work here to keep the tread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ClientThread3 completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 3)
    {
      //Release the mutex region
      printf("ClientThread3 releasing the mutex region\n");
      if (!ReleaseRtControl())
      {
        Fail("ClientThread3 cannot exit region hMutex");
      }

      Iterations = 0;

      //Wait for hMutex region
      if (!WaitForRtControl(hMutex))
      {
        Fail("ClientThread3 Cannot enter region hMutex");
      }
      printf("ClientThread3 has the mutex region, again\n");
    }

//++
  }
}
