// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ClientThread2.c
*
* DESCRIPTION:  This is client module ClientThread2.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
#include <string.h>

#include "RegionPriInvert.h"


void ClientThread2(void)
{
//--
//  RTHANDLE    hRegion;

//  hRegion = CreateRtRegion(FIFO_QUEUING);
//  if (hRegion == BAD_RTHANDLE)
//    Fail("Cannot create region");
//--
//++
  SHORT Counter;
  SHORT Iterations = 0;

#ifdef _DEBUG
  printf("ClientThread2 started\n");
#endif

  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ClientThread2 waiting for start event semaphore\n");
#endif

    if (WaitForRtSemaphore(hClientThread2event, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore hClientThread2event");
//+-

//++
    printf("ClientThread2 running\n");

    // Release ThreadC
    printf("ClientThread2 is releasing ClientThread3\n");

    if ( !ReleaseRtSemaphore(hClientThread3event, 1) )
    {
      Fail("ClientThread2 failed to release hClientThread3event semaphore!");
    }

//++

  while (1)
  {
    // TODO: put client code that must be repeated here
//--
    // the RtSleep call is just an example
//    RtSleep(1000);

//    if (!WaitForRtControl(hRegion))
//      Fail("Cannot enter region");
    
    // use the protected resources

//    if (!ReleaseRtControl())
//      Fail("Cannot exit region");
//--
//++
    // Do some busy work here to keep the thread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ClientThread2 completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 10)
    {
      printf("ClientThread2 sleeping\n");
      Iterations = 0;
      RtSleep(1000);
      printf("ClientThread2 waking up\n");

    }
//++
  }
}
