// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ClientThread1.c
*
* DESCRIPTION:  This is client module ClientThread1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
#include <string.h>

#include "RegionPriInvert.h"


void ClientThread1(void)
{
//--
//  RTHANDLE    hRegion;

//  hRegion = CreateRtRegion(FIFO_QUEUING);
//  if (hRegion == BAD_RTHANDLE)
//    Fail("Cannot create region");
//--
//++
  SHORT Counter;
  SHORT Iterations = 0;
//++

//++
#ifdef _DEBUG
  printf("ClientThread1 started\n");
#endif

  // Wait for event semaphore to start thread activities

#ifdef _DEBUG
    printf("ClientThread1 waiting for start event semaphore\n");
#endif

    if (WaitForRtSemaphore(hClientThread1event, 1, WAIT_FOREVER) == WAIT_FAILED)
      Fail("Cannot receive from semaphore ThreadA");
//++
//+-
#ifdef _DEBUG
    printf("ClientThread1 waiting for mutex region\n");
#endif

    if (!WaitForRtControl(hMutex))
      Fail("Cannot enter region");
    
    // use the protected resources
//+-
//++
    printf("ClientThread1 has control of mutex region\n");

    // Release ClientThread2
    printf("ClientThread1 releasing ClientThread2\n");

    if ( !ReleaseRtSemaphore(hClientThread2event, 1) )
    {
      Fail("ClientThread1 failed to release hClientThread2event semaphore!");
    }//++

  while (1)
  {
    // TODO: put client code that must be repeated here
//--
    // the RtSleep call is just an example
//    RtSleep(1000);
//--

//++
    // Do some busy work here to keep the tread active without introducing sleeps
    for (Counter = 1; Counter != 0; Counter++)
    {
      // Do nothing
      ;
    }

    printf("ClientThread1 completed a counter cycle\n");

    //Increment and check iterations
    if (++Iterations == 5)
    {
      printf("ClientThread1 releasing the mutex region\n");
      if ( !ReleaseRtControl() )
      {
        Fail("ClientThread1 failed to release region!");
      }
      Iterations = 0;
      if (!WaitForRtControl(hMutex))
        Fail("Cannot enter region");
      printf("ClientThread1 has the mutex region, again\n");
    }
//++

  }
}
