// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ClientThread1.c
*
* DESCRIPTION:  This is client module ClientThread1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
#include <string.h>
//++
#include <stdlib.h>
//++

#include "RegionMutex.h"


void ClientThread1(void)
{
//--
//  RTHANDLE    hRegion;

//  hRegion = CreateRtRegion(FIFO_QUEUING);
//  if (hRegion == BAD_RTHANDLE)
//    Fail("Cannot create region");
//--

//++
  int iIter = 0;
  int iChars;
//++

//+-
  while (iIter <= MAX_ITERS)
//  while (1)
  {
//+-
    // TODO: put client code that must be repeated here
//--
    // the RtSleep call is just an example
//    RtSleep(1000);
//--

//++
    printf("Writer Thread waiting for region\n");
//++

//+-
    if (!WaitForRtControl(hMutex))
      Fail("Cannot enter region");
//+-

    // use the protected resources
//++
    // Check that shared buffer is empty
    // Increment iteration count
    iIter++;

    if ( strlen(cSharedBuff) == 0 )
    {
      // Write to shared buffer
      iChars = sprintf(cSharedBuff, "String write iteration: %d", iIter);
      printf("Writer thread wrote %d chars\n", iChars);
    }
    else
    {
      printf("Error! Shared buffer not zeroed\n");
    }
//++

    if (!ReleaseRtControl())
      Fail("Cannot exit region");

  }

//++
  // Signal parent process to exit
  printf("Exiting RegionMutex\n");
  ExitRtProcess();
  printf("Should never get here\n");
//++
}
