// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    mbPort80.c
*
* DESCRIPTION:  This is the thread module for mbPort80.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>
#include <stdlib.h>
#include <string.h>

#include "Port80Rt.h"


/*****************************************************************************
*
* FUNCTION:   ThreadmbPort80
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox mbPort80.
\*****************************************************************************/

void      ThreadmbPort80(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hmbPort80;
  int myPort80_Value = 0;
  char *myPort80_Data = "";
  char *replyMsg = "Message Received: ";

#ifdef _DEBUG
  printf("Thread for mbPort80 started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hmbPort80 = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
  if (hmbPort80 == BAD_RTHANDLE)
    Fail("Cannot create data mailbox mbPort80");
  if (!Catalog(NULL_RTHANDLE, hmbPort80, "mbPort80"))
    Fail("Cannot catalog data mailbox mbPort80");

  while (1) {
#ifdef _DEBUG
    printf("Thread for mbPort80 waiting\n");
#endif

    wActual = ReceiveRtData(hmbPort80, byMessage, WAIT_FOREVER);
    if (wActual == 0)
      Fail("Receive from data mailbox mbPort80 failed");

    // TODO: operate on byMmessage (and dwActual)
	strcpy(replyMsg, "Message Received: ");
	memcpy(myPort80_Data, byMessage, 3);
	myPort80_Value = atoi(myPort80_Data);
	_outp(0x80,myPort80_Value);
		
	strcat(replyMsg, myPort80_Data);

	RtSleep(100);

	//Use the Same mail box to send data back to the Windows Application.
	if(!SendRtData(hmbPort80, replyMsg, 23))
		printf("Data was not sent to the Windows Application");

	

  }
}
