// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

// Port80GUIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Port80GUI.h"
#include "Port80GUIDlg.h"
#include "ntx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CPort80GUIDlg dialog




CPort80GUIDlg::CPort80GUIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPort80GUIDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPort80GUIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPort80GUIDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_txData, &CPort80GUIDlg::OnBnClickedtxdata)
END_MESSAGE_MAP()


// CPort80GUIDlg message handlers

BOOL CPort80GUIDlg::OnInitDialog()
{
	
	NTXHANDLE hINtime_Local, hRemoteAPP;

	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here


	//Launch RTA Application
	hINtime_Local = ntxGetLocationByName("Local");
	if(ntxGetRtStatus(hINtime_Local) !=E_OK)
	{
		MessageBoxEx(NULL, _T("RT Machine not present"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}


	hRemoteAPP = ntxCreateRtProcess(hINtime_Local,"C:\\INtime\\Projects\\Port80Rt\\Port80Rt\\Debug\\Port80Rt.rta", NULL,NULL,NTX_PROC_SHOW_PROGRESS);
	if(hRemoteAPP == NTX_BAD_NTXHANDLE)
	{
		MessageBoxEx(NULL,_T("Cannot Load INtime file"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}



	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPort80GUIDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPort80GUIDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPort80GUIDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CPort80GUIDlg::OnBnClickedtxdata()
{
	// TODO: Add your control notification handler code here
	NTXHANDLE hINtime_Local;
	char send_buf[128];
	char recv_buf[128];
	int recv_buf_size;
	

	//Now begins the sequence to get the mailbox. 
	//1. First we need to conenct to INtime local node
	//2. Then get the root process. 
	//3. Once the root process is established, we get the handle to the Port80Rt applicaiton
	//4. Last step with the handle to the Port80Rt application, we get the handle to the mailbox

	hINtime_Local = ntxGetLocationByName("Local");
	if(ntxGetRtStatus(hINtime_Local) !=E_OK)
	{
		MessageBoxEx(NULL, _T("RT Machine not present"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}

	if((h_RootProcess = ntxGetRootRtProcess(hINtime_Local)) == NTX_BAD_NTXHANDLE)
	{
		MessageBoxEx(NULL, _T("Cannot find root process"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}

	if((h_RTNTXProcess = ntxLookupNtxhandle(h_RootProcess,"Port80Rt",0xffff)) == NTX_BAD_NTXHANDLE)
	{
		MessageBoxEx(NULL, _T("Could not find Port80Rt process"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}

	if((h_RTMAILBOX = ntxLookupNtxhandle(h_RTNTXProcess, "mbPort80",0xffff)) == NTX_BAD_NTXHANDLE)
	{
		MessageBoxEx(NULL, _T("Could not find Port80 mailbox"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
		exit(0);
	}

	//Now that we have gotten the handle to the mailbox lets send the data
	GetDlgItemText(IDC_DATA, send_buf, 30);
	ntxSendRtData(h_RTMAILBOX, send_buf, 3);

	//Now wait for a response back from the INtime process

	if((recv_buf_size = ntxReceiveRtData(h_RTMAILBOX, recv_buf, INFINITE)) == NTX_ERROR)
	{
		if(ntxGetLastRtError() != E_TIME)
		{
			MessageBoxEx(NULL, _T("Failed to receive data"),_T("Port80GUI"), MB_ICONERROR | MB_OKCANCEL, LANG_ENGLISH);
			exit(0);
		}
	}

	//Update Receive edit box
	SetDlgItemText(IDC_rxDATA, recv_buf);
	UpdateData();

}
