// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:  InterruptHndlr1.c
*
* DESCRIPTION:  This is the interrupt handler for interrupt IRQ7
*
\*****************************************************************************/




#include <stdio.h>
#include <rt.h>

#include "ParallelRT.h"

// module global data shared between handler and thread
#define wLevel   IRQ7_LEVEL


/*****************************************************************************
*
* FUNCTION:     InterruptHndlr1
*
* PARAMETERS:   None
*
* RETURNS:      None
*
* DESCRIPTION:  Handles the most critical part of the interrupt.
*               This may vary from just a signal to the appropriate object,
*               to a more elaborate processing of I/O ports.
* NOTE:         In the handler only very few INtime functions may be used!!
\*****************************************************************************/

__INTERRUPT void InterruptHndlr1(void)
{
  // TODO: any local variables are declared here.

    __INTERRUPT_PROLOG();

  // Before EnterRtInterrupt the data segment cannot be used,
  // so we have to obtain the level dynamically
  EnterRtInterrupt(GetRtInterruptLevel());

  // WARNING:
  // inside the handler you should NEVER use the address of
  // a local variable, nor should you call a function (directly
  // or indirectly) that uses the address of a local variable

  // inside the handler there is no need to check results:
  // we cannot display them anyway

  // TODO: process the interrupt in handler context

  // TODO: replace FALSE in the next line by a real expression
  //      or cut it down to just the SignalRtInterruptThread call
  if (/* TODO */ FALSE)
    SignalEndOfRtInterrupt(wLevel);
  else
    SignalRtInterruptThread(wLevel);

  __INTERRUPT_RETURN();
}


/*****************************************************************************
*
* FUNCTION:   InterruptHndlr1Thread
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  Handles the interrupt in normal thread context.
\*****************************************************************************/

void        InterruptHndlr1Thread(
  void*       context)
{

	int portData;
    RTHANDLE	hProcess;
    RTHANDLE	hDmbx;
    BYTE*		pByte;

  if (!SetRtInterruptHandler(wLevel, 16, InterruptHndlr1))
    Fail("Cannot set interrupt handler for IRQ7");

  while (1)
  {
	if (!WaitForRtInterrupt(wLevel, WAIT_FOREVER))
		  Fail("Cannot wait for interrupt signal for IRQ7");

	// TODO: process the interrupt in RT process context

	portData = _inp(0x378);
	_outp(0x80,portData);

	// Find mParallel Mailbox, and get a handle
	hProcess = LookupRtHandle(hRootProcess, "RTDSM", WAIT_FOREVER);
    if (hProcess == BAD_RTHANDLE)
	  {
		Fail("Cannot find data mailbox process");
	  }

	  hDmbx = LookupRtHandle(hProcess, "mailParallel", WAIT_FOREVER);
	  if (hDmbx == BAD_RTHANDLE)
	  {
		Fail("Cannot find data mailbox");
	  }

    // Get byte pointer to Value integer
   pByte = (BYTE*) &portData;

    // Send data to Windows application
	  if (!SendRtData(hDmbx, (LPVOID) pByte, sizeof(portData)))
	  {
		Fail("Cannot send to data mailbox");
	  }




  }
}


/*****************************************************************************
*
* FUNCTION:     InterruptHndlr1Init
*
* PARAMETERS:   None
*
* RETURNS:      BOOL success indication
*
* DESCRIPTION:  Sets up handling of the interrupt, using
*               an interrupt handler and a dedicated thread
\*****************************************************************************/

BOOL        InterruptHndlr1Init(void)
{
  // thread may get a priority that is better than the process currently allows
  SetRtProcessMaxPriority(NULL_RTHANDLE, 0);

  return (CreateRtThread(0, InterruptHndlr1Thread, 4096, 0) != BAD_RTHANDLE);
}


/*****************************************************************************
*
* FUNCTION:     InterruptHndlr1Kill
*
* PARAMETERS:   None
*
* RETURNS:      BOOL success indication
*
* DESCRIPTION:  Terminates handling of the interrupt.
\*****************************************************************************/

BOOL InterruptHndlr1Kill(void)
{
  return ResetRtInterruptHandler(wLevel);
}
