﻿// SJJ Embedded Micro Solutions, LLC.
// Copyright © 2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

//ParallelGUI


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace ParallelGUI
{
    public partial class Form1 : Form
    {

        delegate void SetTextCallback(string text);

        public Thread ParallelProc;

        public Form1()
        {
            InitializeComponent();

            ParallelProc = new Thread(new ThreadStart(ParallelProcessing));
         

            ParallelProc.Start();
        }



        public void ParallelProcessing()
        {

            Int32 loc;
            Int32 ntxRoot;
            Int32 ntxProc;
            Int32 locApp;
            Int32 ParallelMail;

           

            Int16 recDataN;
            Byte recData = 0;


            loc = INtime.ntxGetLocationByName("Local");

            ntxRoot = INtime.ntxGetRootRtProcess(loc);
            ntxProc = INtime.ntxLookupNtxhandle(ntxRoot, "RTDSM", INtime.NTX_INFINITE);

            //Create the mailbox in the RTDSM process and provide a name for the mailbox
            ParallelMail = INtime.ntxCreateRtMailbox(loc, INtime.NTX_DATA_MAILBOX | INtime.NTX_FIFO_QUEUING);
            INtime.ntxCatalogNtxHandle(ntxProc, ParallelMail, "mailParallel");

            //Now start the ParallelRT application
            locApp = INtime.ntxCreateRtProcess(loc, "C:\\INtime\\Projects\\ParallelRT\\ParallelRT\\Debug\\ParallelRt.rta", "", INtime.NTX_PROC_SHOW_PROGRESS);

            //lets sit in this loop and wait for incomming data from the interrupt service routine

            while (true)
            {
                recDataN = INtime.ntxReceiveRtData1Byte(ParallelMail, ref (recData), INtime.NTX_INFINITE);
                               
                string str = System.Uri.HexEscape((char)recData);
                
                this.SetText(str);
                               
                
            }

            
        }

        private void SetText(string text)
        {
            
            // Delegate require for a thread to send data to another thread
            //in a .NET application.
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (this.textParallelData.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textParallelData.Text = text;
            }
        }


       
    }
}
