// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    MShare.c
*
* DESCRIPTION:  This is the thread module for MShare.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "MM_Share.h"


/*****************************************************************************
*
* FUNCTION:   ThreadMShare
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for object mailbox MShare.
\*****************************************************************************/

void      ThreadMShare(void)
{
  RTHANDLE  hSeg, hResp;
//+-
  void *    pObject[NUM_MEM_ALLOCS];
  int i;
	RTHANDLE  rthCurrentProcessHandle;
 	POOLINFO  PoolInfoStruct;
//+-
  RTHANDLE  hMShare;

#ifdef _DEBUG
  printf("Thread for MShare started\n");
#endif

//+-
  // TODO: modify the flags in the following call if they are not appropriate
//  hMShare = CreateRtMailbox(OBJECT_MAILBOX | FIFO_QUEUING);
//  if (hMShare == BAD_RTHANDLE)
//    Fail("Cannot create object mailbox MShare");
//  if (!Catalog(NULL_RTHANDLE, hMShare, "MShare"))
//    Fail("Cannot catalog object mailbox MShare");

  // Look up shared object mailbox
  if ( (hMShare = LookupRtHandle(hRootProcess,"SHARED_MB",WAIT_FOREVER)) == BAD_RTHANDLE)
  {
    Fail("Cannot lookup shared mailbox");
  }

	if ( (rthCurrentProcessHandle = GetRtThreadHandles(THIS_PROCESS)) != (RTHANDLE) NULL )
	{
	  if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	  {
      printf("Starting shared memory thread\n");
		  printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		  printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		  printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		  printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		  printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		  printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	  }
	  else
	  {
		  printf("GetRtProcessPoolInfo failed!\n");
	  }
  }
  else
  {
    Fail("Cannot find current process handle");
  }

//+-
  i = 0;

  while (1) {
#ifdef _DEBUG
    printf("Thread for MShare waiting\n");
#endif

    hSeg    = ReceiveRtHandle(hMShare, WAIT_FOREVER, &hResp); 
    if (hSeg == BAD_RTHANDLE)
      Fail("Receive from object mailbox MShare failed");
    pObject[i]   = MapRtSharedMemory(hSeg);
    if (pObject == NULL)
      Fail("Cannot map segment received on object mailbox MShare");

    // TODO: operate on hSeg via pObject
//++
	  if ( GetRtProcessPoolInfo(rthCurrentProcessHandle, &PoolInfoStruct) )
	  {
      printf("Shared memory loop %d\n", i);
		  printf("Memory Pool Original Size:\t%u (%uK)\n", PoolInfoStruct.cbInitialSize, (PoolInfoStruct.cbInitialSize/1024));
		  printf("Memory Pool Minimum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMin, (PoolInfoStruct.cbPoolMin/1024));
		  printf("Memory Pool Maximum\t\t%u (%uK)\n", PoolInfoStruct.cbPoolMax, (PoolInfoStruct.cbPoolMax/1024));
		  printf("Memory Pool Allocated\t\t%u (%uK)\n", PoolInfoStruct.cbAllocated, (PoolInfoStruct.cbAllocated/1024));
		  printf("Memory Pool Available\t\t%u (%uK)\n", PoolInfoStruct.cbAvailable, (PoolInfoStruct.cbAvailable/1024));
		  printf("Memory Pool Borrowed\t\t%u (%uK)\n\n", PoolInfoStruct.cbBorrowed, (PoolInfoStruct.cbBorrowed/1024));
	  }
	  else
	  {
		  printf("GetRtProcessPoolInfo failed!\n");
	  }
//++

//--
#if 0
    if (hResp == NULL_RTHANDLE)
      DeleteRtMemoryHandle(hSeg);
    else
      SendRtHandle(hResp, hSeg, NULL_RTHANDLE);
#endif
//--
  }
}
