// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreadObject.c
*
* DESCRIPTION:  This is the thread module for ThreadObject.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include <stdlib.h>
#include <BaseTsd.h>
#include <string.h>

#include "MB_Xfer.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreadObject
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for object mailbox ThreadObject.
\*****************************************************************************/

void      ThreadThreadObject(void)
{
  RTHANDLE  hSeg, hResp;
  RTHANDLE  hThreadObject;
  UINT32    uiData = 0;
  BYTE*     bpData = (BYTE*) &uiData;

#ifdef _DEBUG
  printf("Thread for ThreadObject started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hThreadObject = CreateRtMailbox(OBJECT_MAILBOX | FIFO_QUEUING);
  if (hThreadObject == BAD_RTHANDLE)
    Fail("Cannot create object mailbox ThreadObject");
  if (!Catalog(NULL_RTHANDLE, hThreadObject, "ThreadObject"))
    Fail("Cannot catalog object mailbox ThreadObject");

  while (1) {
#ifdef _DEBUG
    printf("Thread for ThreadObject waiting\n");
#endif

    hSeg    = ReceiveRtHandle(hThreadObject, WAIT_FOREVER, &hResp); 
    if (hSeg == BAD_RTHANDLE)
      Fail("Receive from object mailbox ThreadObject failed");

    // TODO: operate on hSeg via pObject

    // Increment data value and send via the data mailbox
    uiData++;
    if ( !SendRtData(hSeg, (LPVOID) bpData, sizeof(uiData)) )
    {
      Fail("SendRtData failed!");
    }

    //Invalidate handle
    hSeg = NULL_RTHANDLE;

    // Sleep
    RtSleep(3000);
  }
}
