// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    ThreadData.c
*
* DESCRIPTION:  This is the thread module for ThreadData.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include <stdlib.h>
#include <BaseTsd.h>
#include <string.h>

#include "MB_Xfer.h"


/*****************************************************************************
*
* FUNCTION:   ThreadThreadData
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox ThreadData.
\*****************************************************************************/

void      ThreadThreadData(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hThreadData;
  RTHANDLE  hObjectMB;
  UINT32    uiData;
  BYTE*     bpData;
  

#ifdef _DEBUG
  printf("Thread for ThreadData started\n");
#endif

  // Get object mailbox handle
  hObjectMB = LookupRtHandle(NULL_RTHANDLE, "ThreadObject", WAIT_FOREVER);
  if (hObjectMB == BAD_RTHANDLE)
  {
    Fail("Cannot find object mailbox");
  }

  // Set byte pointer to point to data integer
  bpData = (BYTE*) &uiData;

  while (1) {
#ifdef _DEBUG
    printf("Thread for ThreadData waiting\n");
#endif

    // TODO: modify the flags in the following call if they are not appropriate
    hThreadData = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
    if (hThreadData == BAD_RTHANDLE)
      Fail("Cannot create data mailbox ThreadData");

    // Send the data mailbox handle to ThreadObject
    if ( !SendRtHandle(hObjectMB, hThreadData, NULL_RTHANDLE) )
    {
      Fail("Send data mailbox handle failed!");
    }

    wActual = ReceiveRtData(hThreadData, byMessage, WAIT_FOREVER);
    if ( wActual != sizeof(uiData) )
      Fail("Receive from data mailbox ThreadData failed");

    // TODO: operate on byMmessage (and dwActual)
    //Get data integer from data mailbox buffer
    memcpy( bpData, byMessage, sizeof(uiData) );

    // Display uiData
    printf("Data received = %u\n", uiData);

    // Delete data mailbox
    if ( !DeleteRtMailbox(hThreadData) )
    {
      Fail("Deletion of data mailbox failed!");
    }
  }
}
