// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    Ping1.c
*
* DESCRIPTION:  This is the thread module for Ping1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include <stdlib.h>
#include <BaseTsd.h>
#include <string.h>

#include "MB_Ping.h"

/*****************************************************************************
*
* FUNCTION:   ThreadPing1
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox Ping1.
\*****************************************************************************/

void      ThreadPing1(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hPing1;
  RTHANDLE	hProcess;
  RTHANDLE	hDmbx;
  UINT32	Value = 0;
  BYTE*		pByte;


#ifdef _DEBUG
  printf("Thread for Ping1 started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hPing1 = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
  if (hPing1 == BAD_RTHANDLE)
    Fail("Cannot create data mailbox Ping1");
  if (!Catalog(NULL_RTHANDLE, hPing1, "Ping1"))
    Fail("Cannot catalog data mailbox Ping1");

  // Find Pong Mailbox, and get a handle
  hProcess = LookupRtHandle(hRootProcess, "MB_Pong", WAIT_FOREVER);
  if (hProcess == BAD_RTHANDLE)
  {
    Fail("Cannot find data mailbox process");
  }

  hDmbx = LookupRtHandle(hProcess, "Pong1", WAIT_FOREVER);
  if (hDmbx == BAD_RTHANDLE)
  {
    Fail("Cannot find data mailbox");
  }

  // Get byte pointer to Value integer
  pByte = (BYTE*) &Value;

  // This kicks of the Ping-Pong with a message to Pong
  if (!SendRtData(hDmbx, (LPVOID) pByte, sizeof(Value)))
  {
    Fail("Cannot send to data mailbox");
  }
            
  printf("The opening value is %u\n", Value);
 

  while (1) {
#ifdef _DEBUG
    printf("Thread for Ping1 waiting\n");
#endif

    wActual = ReceiveRtData(hPing1, byMessage, WAIT_FOREVER);
    if (wActual != sizeof(Value))
    {
      Fail("Receive from data mailbox Ping1 failed, received %u bytes!\n", wActual);
    }

    // TODO: operate on byMmessage (and dwActual)
    memcpy(pByte, byMessage, wActual);

    RtSleep(3000);

    // Display and increment Value
    printf("PING: Value received: %u\n", Value++);
    // Display returned Value
    printf("PING: Value sent:     %u\n", Value);

    if (!SendRtData(hDmbx, (LPVOID) pByte, sizeof(Value)))
    {
      Fail("Cannot send to data mailbox");
    }

  }
}
