// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    EventSource.c
*
* DESCRIPTION:  This is the thread module for EventSource.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

//++
#include <stdlib.h>
#include <BaseTsd.h>
#include <string.h>
//++

#include "MB_Event.h"


/*****************************************************************************
*
* FUNCTION:   ThreadEventSource
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox EventSource.
\*****************************************************************************/

void      ThreadEventSource(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hEventSource;

//++
  RTHANDLE  hHandlerMB;
  BYTE      bEvent = 0;
  int       iEvent;
//++

#ifdef _DEBUG
  printf("Thread for EventSource started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hEventSource = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
  if (hEventSource == BAD_RTHANDLE)
    Fail("Cannot create data mailbox EventSource");
  if (!Catalog(NULL_RTHANDLE, hEventSource, "EventSource"))
    Fail("Cannot catalog data mailbox EventSource");

//++
  // Find event handler mailbox
  if ( ( hHandlerMB = LookupRtHandle(NULL_RTHANDLE, "EventHandler", WAIT_FOREVER) ) == BAD_RTHANDLE )
  {
    Fail("EventHandler mailbox not found!");
  }

  // Seed the random number generator
  srand(3);
//++

  while (1) {

//++
    // Generate random event code
    iEvent = rand();
    iEvent &= VALID_MASK;
    while ( (iEvent == 0) || (iEvent == bEvent) )
    {
      iEvent = rand();
      iEvent &= VALID_MASK;
    }
    bEvent = (BYTE) iEvent;

    // Send random event code to EventHandler
    if (!SendRtData(hHandlerMB, &bEvent, sizeof(bEvent)))
    {
      Fail("EventSource: mailbox send failed!");
    }

//++

#ifdef _DEBUG
    printf("Thread for EventSource waiting\n");
#endif

    wActual = ReceiveRtData(hEventSource, byMessage, WAIT_FOREVER);
//+-
//    if (wActual == 0)
//      Fail("Receive from data mailbox EventSource failed");
    if (wActual != sizeof(bEvent))
    {
      Fail("EventSource: Receive from data mailbox EventSource failed!");
    }
//+-
    // TODO: operate on byMmessage (and dwActual)
//++
    //Check for acknowledge
    bEvent = byMessage[0] & VALID_MASK;
    if (byMessage[0] & ACK_MASK)
    {
      switch (bEvent)
      {
      case TX_STARTED:
        {
          printf("EventSource: Tx Started Event Acknowledged\n");
          break;
        }
      case TX_COMPLETE:
        {
          printf("EventSource: Tx Complete Event Acknowledged\n");
          break;
        }
      case RX_READY:
        {
          printf("EventSource: Rx Ready Event Acknowledged\n");
          break;
        }
      default:
        {
          printf("EventSource: Unknown Event Code Acknowledged: 0x%x\n", (byMessage[0] & VALID_MASK));
          break;
        }
      }
    }
    else
    {
      Fail("EventSource: Acknowledge bit not set: 0x%x", byMessage[0]);
    }
//++
  }
}
