// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    EventHandler.c
*
* DESCRIPTION:  This is the thread module for EventHandler.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

//++
#include <stdlib.h>
#include <BaseTsd.h>
#include <string.h>
//++

#include "MB_Event.h"


/*****************************************************************************
*
* FUNCTION:   ThreadEventHandler
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox EventHandler.
\*****************************************************************************/

void      ThreadEventHandler(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hEventHandler;

//++
  RTHANDLE  hSourceMB;
  BYTE      bSignal;
//++

#ifdef _DEBUG
  printf("Thread for EventHandler started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hEventHandler = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
  if (hEventHandler == BAD_RTHANDLE)
    Fail("Cannot create data mailbox EventHandler");
  if (!Catalog(NULL_RTHANDLE, hEventHandler, "EventHandler"))
    Fail("Cannot catalog data mailbox EventHandler");

//++
  // Find event source mailbox
  if ( ( hSourceMB = LookupRtHandle(NULL_RTHANDLE, "EventSource", WAIT_FOREVER) ) == BAD_RTHANDLE )
  {
    Fail("EventSource mailbox not found!");
  }

//++

  while (1) {
#ifdef _DEBUG
    printf("Thread for EventHandler waiting\n");
#endif

    wActual = ReceiveRtData(hEventHandler, byMessage, WAIT_FOREVER);
//+-
//    if (wActual == 0)
//      Fail("Receive from data mailbox EventHandler failed");
    if (wActual != sizeof(BYTE))
    {
      Fail("EventHandler: Receive from data mailbox EventHandler failed");
    }
//+-
    // TODO: operate on byMmessage (and dwActual)
//++
    //Display event
      switch (byMessage[0] & VALID_MASK)
      {
      case TX_STARTED:
        {
          printf("EventHandler: Tx Started Event Received\n");
          RtSleep((byMessage[0] & VALID_MASK) * 1000);
          break;
        }
      case TX_COMPLETE:
        {
          printf("EventHandler: Tx Complete Event Received\n");
          RtSleep((byMessage[0] & VALID_MASK) * 1000);
          break;
        }
      case RX_READY:
        {
          printf("EventHandler: Rx Ready Event Received\n");
          RtSleep((byMessage[0] & VALID_MASK) * 1000);
          break;
        }
      default:
        {
          printf("EventHandler: Unknown Event Code Received: 0x%x\n", (byMessage[0] & VALID_MASK));
          break;
        }
      }

      //Send acknowledge
      bSignal = byMessage[0] | ACK_MASK;
      if (!SendRtData(hSourceMB, &bSignal, sizeof(bSignal)))
      {
        Fail("EventHandler: Send acknowledge failed!");
      }
//++
  }
}
