// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

//Code supplied as is without any warranty
/*****************************************************************************
*
* FILE NAME:    PollThread1.c
*
* DESCRIPTION:  This is polling module PollThread1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "MB_Basic.h"


/*****************************************************************************
*
* FUNCTION:		PollThread1
*
* PARAMETERS:	None
*
* RETURNS:		None
*
* DESCRIPTION:  This is polling thread PollThread1.
\*****************************************************************************/

void			PollThread1(void)
{
RTHANDLE hmyMail;
#ifdef _DEBUG
	printf("PollThread1 started\n");

#endif

	hmyMail = LookupRtHandle(NULL_RTHANDLE, "MailBox1", WAIT_FOREVER);

	  if (hmyMail == BAD_RTHANDLE) 
		  Fail("Cannot find data mailbox");

	while (1)
	{
		RtSleep(5500);

#ifdef _DEBUG
		printf("PollThread1 waking up\n");
#endif

		// TODO: do what has to be done every 5500 milliseconds
		if (!SendRtData(hmyMail, "Message from Polling Thread", 128))
				Fail("Cannot send to data mailbox");
	}
}
