// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

//Code supplied as is without any warranty

/*****************************************************************************
*
* FILE NAME:    MailBox1.c
*
* DESCRIPTION:  This is the thread module for MailBox1.
*
\*****************************************************************************/

#include <stdio.h>
#include <rt.h>

#include "MB_Basic.h"


/*****************************************************************************
*
* FUNCTION:   ThreadMailBox1
*
* PARAMETERS: None
*
* RETURNS:    None
*
* DESCRIPTION:  This is the thread for data mailbox MailBox1.
\*****************************************************************************/

void      ThreadMailBox1(void)
{
  WORD      wActual;
  BYTE      byMessage[128];
  RTHANDLE  hMailBox1;

#ifdef _DEBUG
  printf("Thread for MailBox1 started\n");
#endif

  // TODO: modify the flags in the following call if they are not appropriate
  hMailBox1 = CreateRtMailbox(DATA_MAILBOX | FIFO_QUEUING);
  if (hMailBox1 == BAD_RTHANDLE)
    Fail("Cannot create data mailbox MailBox1");
  if (!Catalog(NULL_RTHANDLE, hMailBox1, "MailBox1"))
    Fail("Cannot catalog data mailbox MailBox1");

  while (1) {
#ifdef _DEBUG
    printf("Thread for MailBox1 waiting\n");
#endif

    wActual = ReceiveRtData(hMailBox1, byMessage, WAIT_FOREVER);
    if (wActual == 0)
      Fail("Receive from data mailbox MailBox1 failed");

    // TODO: operate on byMmessage (and dwActual)
	printf("This is the Message: %s\n", byMessage);

  }
}
