// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    PollThread1.cpp
*
* DESCRIPTION:  This is poll class CIPollThread1.
*
\*****************************************************************************/

#include <iostream>
#include "CPPBasic.h"


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
// the CIPollThread1 class

///////////////////////////////////////////////////////////////////////
// constructor

CIPollThread1::    CIPollThread1()
  : CIPollThread()
{
  // TODO: any further initialization
//++
	lookup	= FALSE;
  iNum    = 0;
  
//++
}


///////////////////////////////////////////////////////////////////////
// destructor

CIPollThread1::    ~CIPollThread1()
{
}


///////////////////////////////////////////////////////////////////////
// overruled OnPoll

BOOL CIPollThread1:: OnPoll(void)
{
#ifdef _DEBUG
    _STD cout << "PollThread1 waking up" << _STD endl;
#endif

  // TODO: do what has to be done every 1000 milliseconds
//++
  //Increment a number and mail it to WaitMailBox via the data mailbox
  // Print out received integer
	if (!lookup)
	{
		if (mbx.Lookup("WaitMailBox") == E_OK)
    {
			lookup	= TRUE; // next cycle we will send
      _STD cout << "Found mailbox" << _STD endl;

    }
    else
    {
      _STD cout << "Mailbox not found!" << _STD endl;
    }
	}
	else
  {
    // Send after lookup
    _STD cout << "PollThread1 sending " << iNum << _STD endl;
    mbx.Send((PVOID) &iNum, sizeof(int) );
    iNum++;
  }
//++

  return TRUE;
}
