// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

// include file for the CPPBasic project

#include <rtpp.h>

//{{INTERRUPTS : includes
//}}

//{{MBXSEMS : includes

#include "WaitMailBox.h"

//}}

//{{POLLS : includes

#include "PollThread1.h"

//}}

//{{CLIENTS : includes
//}}


///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
// the CICPPBasicApp class

class				CICPPBasicApp
						: public CIApp
{
public:
	// constructor
					CICPPBasicApp(char * pszName)
						: CIApp(pszName)
						{}

	// overruled functions of baseclass
	BOOL			InitInstance(void);
	int				ExitInstance(void);
	BOOL			OnNotify(LPEVENTINFO pEI);

private:
//{{MEMS : members
//}}

//{{INTERRUPTS : members
//}}

//{{MBXSEMS : members

	DECLARE_MBXSEM(WaitMailBox)

//}}

//{{POLLS : members

	DECLARE_POLL(PollThread1)

//}}

//{{CLIENTS : members
//}}

};

extern CICPPBasicApp		theApp;
//{{MBXSEMS : externs


//}}
