// SJJ Embedded Micro Solutions, LLC.
// Copyright  2009 SJJ Embedded Micro Solutions, LLC. All Rights Reserved
//  
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.

/*****************************************************************************
*
* FILE NAME:    CPPBasic.cpp
*
* DESCRIPTION:  Implementation of the CPPBasic application class.
*
\*****************************************************************************/

#include <iostream>
#include "CPPBasic.h"

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
// the CICPPBasicApp class


///////////////////////////////////////////////////////////////////////
// declare an instance of the application class

CICPPBasicApp   theApp("CPPBasic");
//{{MBXSEMS : globals


//}}

///////////////////////////////////////////////////////////////////////
// overruled InitInstance

BOOL CICPPBasicApp::  InitInstance(void)
{
  // do whatever base class wants to do
  CIApp::InitInstance();

#ifdef _DEBUG
  _STD cout << "Entering CICPPBasicApp::InitInstance argc="
    << m_iArg << _STD endl;
  for (int i=0; i<m_iArg; i++)
    _STD cout << "Argv[" << i << "] = " << m_pArg[i] << _STD endl;
#endif

  // adjust process max priority (ignore error)
  ::SetRtProcessMaxPriority(NULL_RTHANDLE, 150);

  //{{MEMS : create shared memory
  //}}

  //{{MBXSEMS : create mailbox and semaphore threads

  CREATE_MBXSEM_DMBX(WaitMailBox, 160, 4096)

  //}}

  //{{INTERRUPTS : create interrupt handling objects
  //}}

  //{{POLLS : create polling threads

  CREATE_POLL_MSEC(PollThread1, 1000, 170, 4096)

  //}}

  //{{CLIENTS : create client threads
  //}}

  return TRUE;
}


///////////////////////////////////////////////////////////////////////
// overruled OnNotify

BOOL CICPPBasicApp::OnNotify(LPEVENTINFO pEI)
{
  // react to notification
  // return FALSE to terminate the application

  switch(pEI->dwNotifyType)
  {
  case TERMINATE:
    // TODO: this process should terminate
    // cleanup the environment
    return FALSE;

  case RT_CLIENT_DOWN:
    // TODO: on a NT host react to a RT client that has gone down
    return TRUE;

  case RT_CLIENT_UP:
    // TODO: on a NT host react to a RT client that has come back
    return TRUE;

  case NT_HOST_DOWN:
    // TODO: on a RT client react to a NT host that has gone down
    return TRUE;

  case NT_HOST_UP:
    // TODO: on a RT client react to a NT host that has come back
    return TRUE;

  case NT_BLUESCREEN:
    // TODO: react to a NT blue screen
    return TRUE;

  default:
    Fail("Unknown notification");
    return FALSE; // This will never happen
  }

  // For the compiler's sake...
  return FALSE;
}


///////////////////////////////////////////////////////////////////////
// overruled ExitInstance

int CICPPBasicApp::ExitInstance(void)
{
#ifdef _DEBUG
  _STD cout << "Leaving CICPPBasicApp" << _STD endl;
#endif

  // do whatever base class wants to do
  return CIApp::ExitInstance();
}
